#include <bits/stdc++.h>
using namespace std;

struct Vec {
    long long x, y;
    double ang;
    int id;
};

static inline long long sq(long long a) { return a * a; }

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<Vec> a;
    a.reserve(n);

    for (int i = 1; i <= n; i++) {
        long long x, y;
        cin >> x >> y;
        if (x == 0 && y == 0) continue; // nikad ne pomaže
        a.push_back({x, y, atan2((double)y, (double)x), i});
    }

    int m = (int)a.size();
    if (m == 0) {
        cout << 0 << "\n\n";
        return 0;
    }

    sort(a.begin(), a.end(), [](const Vec& p, const Vec& q){
        return p.ang < q.ang;
    });

    // dupliramo sa +2pi zbog kružnog intervala
    const double TWO_PI = 2.0 * M_PI;
    vector<Vec> b;
    b.reserve(2 * m);
    for (int i = 0; i < m; i++) b.push_back(a[i]);
    for (int i = 0; i < m; i++) {
        Vec t = a[i];
        t.ang += TWO_PI;
        b.push_back(t);
    }

    long long sumx = 0, sumy = 0;
    long long bestVal = -1;
    int bestL = 0, bestR = 0;

    int r = 0;
    for (int l = 0; l < m; l++) {
        if (r < l) { r = l; sumx = 0; sumy = 0; }

        // proširi prozor dok je ugaona razlika <= pi i ne uzmemo više od m vektora
        while (r < l + m && b[r].ang - b[l].ang <= M_PI + 1e-12) {
            sumx += b[r].x;
            sumy += b[r].y;
            r++;
        }

        long long val = sq(sumx) + sq(sumy);
        if (val > bestVal) {
            bestVal = val;
            bestL = l;
            bestR = r;
        }

        // izbacimo b[l] pre sledeceg l
        sumx -= b[l].x;
        sumy -= b[l].y;
    }

    vector<int> ans;
    ans.reserve(bestR - bestL);
    for (int i = bestL; i < bestR; i++) {
        ans.push_back(b[i].id);
    }

    cout << ans.size() << "\n";
    for (int i = 0; i < (int)ans.size(); i++) {
        if (i) cout << " ";
        cout << ans[i];
    }
    cout << "\n";
    return 0;
}